	org 60758
	; FINAL VALUE

	; ROUTINE 1: erase the top third of the screen, print the Illuminati II title
	ld bc,2047
	call blackout
	ld hl,22528
	ld (hl),6	; most of this is yellow ink on black paper
	ld de,22529
	ld bc,255
	ldir
	; now call ZX0 to decompress the title into the top third of the screen
	ld hl,titledata
	ld de,16384
	call dzx0_standard
	; colour in the eye, subtitle and year
	ld hl,22709
	ld (hl),86
	; colour in the subtitle
	ld ix,22688
	ld b,17
	call colourloop
	ld ix,22714
	ld b,6
	call colourloop
	ret
colourloop:
	ld (ix+0),2
	ld (ix+32),2
	inc ix
	djnz colourloop
	ret

	
	; ROUTINE 2: blank out screen and print main pyramid screen
	ld bc,6911
	call blackout
	; call ZX0 to print the screen
	ld hl,pyramiddata
	ld de,16384
	call dzx0_standard
	ret


	; ROUTINE 3: blank out screen and print 2022 USA map (cyan, no borders)
	ld bc,6911
	call blackout
	; call ZX0 to print the map
	ld hl,mapdata1
	ld de,16384
	call dzx0_standard
	ret


	; ROUTINE 4: alter the title and reveal the map borders
	; draw line through "UNITED STATES OF"
	ld de,1760	; difference between lines
	ld hl,18176	; bottom line of (0,0)
	ld (hl),3	; fill in two rightmost pixels
	and a		; clear flags
	sbc hl,de	; top line of (1,0) at 16416 - 1760 less than last HL value
	ld (hl),3	; fill as before
	ld b,16
lineloop:
	inc hl		; move right
	add hl,de	; move up
	ld (hl),255	; fill the line
	and a		; clear flags
	sbc hl,de	; move down
	ld (hl),255	; fill the line
	djnz lineloop
	inc hl		; move right - now at top line of (1,17)
	ld (hl),224	; fill in three lefttmost pixels
	add hl,de	; move up - bottom line of (0,17)
	ld (hl),224	; fill in three lefttmost pixels
	; turn these lines red
	ld hl,22528	; start at (0,0)
	ld de,32	; define DE as the difference between rows
	ld b,18		; perform the loop 18 times
redloop:
	ld (hl),66	; bright red on black
	add hl,de	; move down
	ld (hl),66	; colour the line below the same way
	and a
	sbc hl,de	; back to where we were
	inc hl		; move right
	djnz redloop
	; turn "2022" into "2042"
	ld de,1760	; difference between bottom line of (0,29) and top line of (1,29)
	ld hl,17725	; sixth row of (1,29)
	ld (hl),6
	dec h		; decrease HL by 256 - up one line
	ld (hl),6
	dec h
	ld (hl),127
	dec h
	ld (hl),127
	dec h
	ld (hl),54
	dec h
	ld (hl),54	; filled top line of (1,29)
	add hl,de	; now at bottom line of (0,29)
	ld (hl),30
	dec h
	ld (hl),30
	dec h
	ld (hl),14
	dec h
	ld (hl),14
	dec h
	ld (hl),6
	dec h
	ld (hl),6
	; call ZX0 to print the map
	ld hl,mapdata2
	ld de,22626
	call dzx0_standard
	ret

blackout:
	ld hl,16384
	ld (hl),0
	ld de,16385
	ldir
	ret

; -----------------------------------------------------------------------------
; ZX0 decoder by Einar Saukas & Urusergi
; "Standard" version (68 bytes only)
; -----------------------------------------------------------------------------
; Parameters:
;   HL: source address (compressed data)
;   DE: destination address (decompressing)
; -----------------------------------------------------------------------------

dzx0_standard:
        ld      bc, $ffff               ; preserve default offset 1
        push    bc
        inc     bc
        ld      a, $80
dzx0s_literals:
        call    dzx0s_elias             ; obtain length
        ldir                            ; copy literals
        add     a, a                    ; copy from last offset or new offset?
        jr      c, dzx0s_new_offset
        call    dzx0s_elias             ; obtain length
dzx0s_copy:
        ex      (sp), hl                ; preserve source, restore offset
        push    hl                      ; preserve offset
        add     hl, de                  ; calculate destination - offset
        ldir                            ; copy from offset
        pop     hl                      ; restore offset
        ex      (sp), hl                ; preserve offset, restore source
        add     a, a                    ; copy from literals or new offset?
        jr      nc, dzx0s_literals
dzx0s_new_offset:
        pop     bc                      ; discard last offset
        ld      c, $fe                  ; prepare negative offset
        call    dzx0s_elias_loop        ; obtain offset MSB
        inc     c
        ret     z                       ; check end marker
        ld      b, c
        ld      c, (hl)                 ; obtain offset LSB
        inc     hl
        rr      b                       ; last offset bit becomes first length bit
        rr      c
        push    bc                      ; preserve new offset
        ld      bc, 1                   ; obtain length
        call    nc, dzx0s_elias_backtrack
        inc     bc
        jr      dzx0s_copy
dzx0s_elias:
        inc     c                       ; interlaced Elias gamma coding
dzx0s_elias_loop:
        add     a, a
        jr      nz, dzx0s_elias_skip
        ld      a, (hl)                 ; load another group of 8 bits
        inc     hl
        rla
dzx0s_elias_skip:
        ret     c
dzx0s_elias_backtrack:
        add     a, a
        rl      c
        rl      b
        jr      dzx0s_elias_loop
; -----------------------------------------------------------------------------

titledata:
defb 132,254,34,255,254,6,129,0,103,15,231,240,134,228,111,1,248,3,192,78
defb 151,175,127,7,214,35,31,129,161,192,62,15,240,7,224,127,3,248,1,252
defb 63,246,58,15,224,196,186,62,146,94,15,193,248,31,131,248,7,193,11,192
defb 31,192,252,175,182,63,251,250,253,131,255,127,243,192,132,4,135,255,135,195
defb 225,255,216,24,30,12,51,48,6,102,51,99,48,112,241,231,99,251,102,96
defb 108,130,5,15,227,255,199,228,129,128,0,1,193,153,249,192,127,5,244,216
defb 192,54,0,1,153,252,1,248,5,160,15,106,240,168,224,224,137,126,1,26
defb 126,90,63,42,71,96,143,224,63,152,15,192,127,137,15,192,34,1,135,34
defb 31,195,128,99,63,51,62,7,193,204,25,225,224,62,62,28,62,48,60,60
defb 99,123,63,89,127,120,0,32,240,240,48,240,139,103,243,218,245,1,127,105
defb 102,138,7,253,32,191,224,162,129,216,128,72,29,206,0,216,95,186,93,146
defb 0,42,1,227,7,18,39,3,192,125,210,232,0,60,130,240,30,7,129,108
defb 7,173,30,62,106,119,255,47,15,1,247,103,61,0,63,128,126,55,199,162
defb 182,120,0,105,192,40,248,173,240,124,27,119,216,243,0,125,137,119,95,163
defb 120,0,152,31,220,249,31,221,237,121,216,63,191,131,0,106,225,8,27,243
defb 240,63,169,63,162,126,126,102,31,248,253,75,247,134,1,1,249,248,49,248
defb 87,227,255,5,1,255,183,255,128,253,104,0,129,152,49,118,122,60,5,113
defb 64,63,127,135,217,254,221,7,241,252,167,49,134,221,0,168,254,36,3,248
defb 127,255,134,7,241,254,127,243,130,241,255,15,243,161,240,152,255,255,223,152
defb 127,207,248,10,192,64,170,135,143,130,7,240,255,193,98,63,252,168,15,170
defb 63,253,31,166,248,159,207,7,29,230,64,99,102,51,10,54,29,166,1,240
defb 130,15,11,153,152,113,152,41,192,130,236,25,195,103,193,191,62,182,4,215
defb 219,254,252,39,192,117,0,110,239,254,22,225,255,234,183,15,0,10,31,25
defb 154,63,129,252,1,42,7,32,255,127,245,103,203,145,22,119,147,109,187,246
defb 160,118,59,1,136,143,138,63,199,131,170,7,31,170,15,124,137,240,3,189
defb 224,247,237,202,252,194,0,10,3,255,239,225,162,7,127,248,96,160,127,251
defb 248,127,133,254,31,207,255,42,108,134,63,133,252,171,204,193,14,192,103,193
defb 190,62,237,4,255,246,252,1,35,248,240,88,70,15,5,136,226,147,1,252
defb 117,0,98,31,193,66,32,63,128,116,109,96,223,129,149,233,122,0,252,26
defb 15,162,127,134,15,140,193,99,128,96,0,24,104,134,15,12,30,0,130,143
defb 129,130,240,105,243,249,255,149,255,159,195,164,128,167,96,24,0,222,130,13
defb 57,152,240,56,128,64,218,0,169,3,192,217,64,75,255,115,0,115,56,117
defb 0,109,63,28,64,40,126,106,127,245,254,129,189,26,55,217,71,0,162,248
defb 122,127,199,254,11,127,237,246,203,143,206,105,1,7,106,248,156,240,94,64
defb 38,3,240,102,3,240,127,36,254,126,25,96,7,247,253,255,191,239,224,49
defb 222,81,0,42,49,192,62,26,120,138,127,62,162,129,124,254,104,113,160,112
defb 31,37,87,172,54,0,87,205,176,205,56,88,0,90,7,160,224,109,14,194
defb 0,129,28,214,27,58,1,192,175,0,193,138,64,7,9,158,131,252,3,246
defb 223,0,87,115,103,64,112,0,160,7,164,7,164,127,72,162,255,227,199,255
defb 67,7,64,182,224,1,150,99,24,31,135,195,225,248,32,128,225,153,176,224
defb 3,85,85,128

pyramiddata:
defb 132,0,189,1,238,165,128,245,242,161,60,125,192,105,15,164,120,166,30,149
defb 240,233,63,62,224,66,160,124,94,133,99,1,255,255,232,249,3,30,6,251
defb 31,248,254,248,188,133,154,127,248,248,83,159,194,203,254,251,244,198,7,102
defb 197,112,15,255,32,138,63,128,1,252,255,165,14,119,0,170,1,128,74,1
defb 161,128,74,62,74,124,16,140,7,128,150,192,37,1,224,61,148,126,109,120
defb 6,141,28,218,207,1,15,170,224,56,1,166,14,42,63,248,3,42,192,38
defb 31,252,128,112,98,63,252,95,236,224,196,111,192,69,237,244,3,230,0,224
defb 3,252,4,161,3,40,192,82,146,30,132,120,34,3,224,41,28,40,56,136
defb 7,192,6,144,254,160,127,91,6,107,10,128,90,1,1,170,240,96,17,138
defb 127,240,138,7,224,136,15,254,71,55,195,0,104,31,7,243,207,211,137,96
defb 65,138,31,224,7,248,255,255,224,58,90,7,220,150,171,3,224,100,0,105
defb 127,40,254,66,33,1,248,123,49,128,148,134,222,129,122,19,250,135,12,1
defb 191,63,199,186,175,252,133,164,123,3,110,31,188,223,10,207,129,246,104,1
defb 3,18,37,127,240,203,190,33,198,55,18,216,1,179,240,15,238,200,186,79
defb 149,118,18,190,7,109,254,23,244,144,232,194,255,70,233,252,35,14,41,112
defb 245,196,207,218,247,246,129,207,1,166,53,198,161,128,223,214,63,244,186,183
defb 254,128,83,101,0,28,213,128,252,186,55,88,125,115,198,53,233,180,64,243
defb 24,83,119,74,199,2,16,167,6,74,186,132,96,59,11,192,62,138,254,250
defb 133,5,240,87,26,13,192,31,239,184,250,188,241,233,212,128,199,0,67,12
defb 128,67,97,0,244,128,222,166,154,48,240,94,130,160,12,76,105,161,3,44
defb 192,181,172,36,190,51,2,214,254,212,129,194,223,72,250,246,141,63,227,242
defb 125,56,29,128,77,29,0,13,12,128,23,193,137,221,128,97,130,108,28,134
defb 152,155,31,56,33,60,119,0,114,68,23,61,132,223,253,0,207,5,124,8
defb 254,76,212,197,156,192,199,189,2,193,213,128,193,213,0,192,213,128,245,0
defb 118,128,81,254,60,254,75,248,36,128,38,0,7,232,38,23,224,0,17,248
defb 194,227,231,239,67,247,231,66,4,67,222,132,124,124,132,31,124,175,247,132
defb 23,221,124,53,0,113,144,128,113,218,0,0,74,0,16,184,48,238,162,8
defb 134,16,188,12,254,19,249,132,124,244,132,95,124,117,53,0,116,100,128,92
defb 29,64,187,126,254,2,186,70,226,64,194,194,120,68,226,190,128,2,61,132
defb 247,124,215,254,222,132,124,124,132,95,254,241,132,125,124,196,213,0,193,145
defb 128,55,0,164,252,40,63,6,148,0,165,0,85,213,37,0,29,71,128,87
defb 35,218,101,0,136,31,128,69,29,19,0,87,65,213,128,206,162,132,224,212
defb 144,190,213,198,0,149,0,87,20,149,0,113,29,128,94,137,253,128,246,15
defb 4,23,64,136,1,224,83,67,8,197,193,64,254,132,124,124,132,31,248,252
defb 191,132,15,124,124,132,77,156,248,18,0,81,221,26,108,124,24,64,10,15
defb 82,220,240,0,23,119,196,113,0,29,151,64,112,0,31,193,37,128,252,193
defb 68,95,60,125,132,125,124,61,132,125,124,125,132,57,124,92,108,224,149,158
defb 175,255,254,16,48,249,148,248,124,132,7,197,124,54,1,144,192,40,3,17
defb 111,126,254,77,12,132,13,13,124,244,132,63,254,215,132,193,124,255,164,124
defb 3,105,1,128,2,148,1,20,164,0,10,0,80,70,145,254,45,127,93,0
defb 1,109,252,193,88,165,63,83,3,132,92,13,124,113,53,132,196,211,124,215
defb 132,215,124,211,132,192,124,197,229,115,254,61,191,233,0,248,18,129,31,19
defb 117,196,217,0,71,97,64,118,0,5,105,240,18,128,15,18,225,56,254,174
defb 5,218,126,241,214,72,151,56,0,251,208,246,207,242,251,222,130,246,247,212
defb 223,128,230,245,192,160,0,184,65,254,250,192,0,71,230,225,196,15,121,121
defb 122,122,249,159,188,255,151,128,230,229,194,57,66,66,190,253,255,64,63,255
defb 195,223,192,191,223,216,128,104,5,7,228,255,0,29,218,128,0,78,232,54
defb 0,22,243,6,254,97,0,123,222,253,202,244,245,192,255,254,130,126,192,129
defb 0,60,132,231,238,215,192,223,132,124,95,193,199,132,215,124,241,193,132,245
defb 124,252,193,132,125,124,127,193,132,121,124,31,193,222,132,124,71,239,193,236
defb 254,3,186,192,255,55,161,48,95,205,189,130,254,83,85,85,128

mapdata1:
defb 128,0,9,164,99,111,24,234,96,99,0,3,24,127,243,3,79,99,96,0
defb 127,107,96,235,224,251,189,131,63,99,63,63,213,248,34,7,231,60,112,96
defb 36,37,229,15,73,222,148,184,52,164,7,41,252,24,154,127,224,127,41,1
defb 230,250,135,254,218,226,255,230,130,225,15,220,247,246,138,150,248,55,0,16
defb 161,126,168,126,128,126,126,66,155,199,240,193,192,183,15,0,10,242,0,104
defb 248,38,48,227,130,42,3,132,252,104,252,105,3,45,99,154,117,255,127,124
defb 122,62,255,62,243,62,54,81,98,62,99,127,254,62,235,239,254,214,0,166
defb 103,170,103,99,138,99,99,8,170,99,99,102,106,99,99,12,96,136,96,96
defb 16,35,255,192,97,0,104,3,41,31,26,255,8,160,1,32,138,73,145,50
defb 128,240,127,220,101,0,160,240,152,64,146,65,40,248,161,15,10,224,86,187
defb 126,246,237,242,127,163,1,127,239,239,240,239,183,254,0,41,102,74,103,20
defb 105,7,86,130,207,132,255,144,129,14,231,153,196,25,47,56,148,166,72,23
defb 128,41,239,146,2,14,48,74,85,74,104,248,22,38,224,3,98,232,227,129
defb 168,15,240,2,134,254,250,1,144,7,61,195,168,64,115,104,96,40,96,106
defb 119,156,99,254,204,244,177,127,207,37,206,179,192,198,223,0,200,219,193,135
defb 99,12,96,0,74,12,165,240,96,37,37,232,143,73,208,100,184,24,162,191
defb 138,127,252,6,22,16,148,36,132,37,72,64,150,169,104,63,90,1,22,38
defb 255,64,24,41,64,123,213,122,74,1,66,10,194,7,112,28,38,144,130,168
defb 255,224,70,32,248,3,10,103,68,160,62,170,124,62,10,62,165,62,160,62
defb 160,62,70,169,14,255,88,9,53,10,136,106,16,150,164,32,104,255,98,255
defb 254,2,38,22,231,106,142,48,149,88,166,192,149,63,136,231,192,38,74,74
defb 74,119,8,221,0,96,166,134,31,248,127,104,138,82,162,15,146,128,129,31
defb 164,255,166,252,138,15,224,10,123,34,126,99,166,126,35,126,126,181,250,199
defb 37,42,209,168,65,3,145,3,3,40,24,20,216,1,169,15,135,240,73,42
defb 45,202,142,90,208,149,116,74,15,88,150,255,255,104,18,164,60,42,61,72
defb 8,148,72,17,162,255,168,1,52,105,255,105,3,14,110,167,243,253,86,203
defb 130,0,25,17,121,221,238,72,98,240,7,10,7,40,240,74,63,10,63,17
defb 8,162,7,231,255,128,70,74,37,5,8,74,80,244,132,72,223,4,125,76
defb 89,0,130,151,164,135,165,136,112,100,188,127,223,93,64,123,180,135,110,122
defb 0,3,105,7,90,224,26,255,161,250,33,150,21,66,9,9,104,37,228,15
defb 191,248,200,200,192,34,113,137,206,88,134,0,130,31,147,31,249,157,124,49
defb 8,82,133,19,212,189,203,156,240,239,221,61,127,102,48,166,251,63,88,4
defb 61,207,74,73,50,64,222,44,42,252,63,195,119,98,60,111,150,194,169,240
defb 248,98,224,248,79,112,55,126,120,122,190,6,83,106,117,140,64,55,126,35
defb 184,209,213,213,131,48,232,253,197,60,196,211,120,125,185,190,224,192,205,134
defb 247,130,97,0,134,10,64,73,10,72,90,248,166,248,138,127,240,6,72,15
defb 92,244,146,82,165,31,106,237,176,222,0,254,77,226,0,254,127,160,255,160
defb 224,161,7,72,33,3,227,240,124,162,15,133,127,254,143,73,214,191,188,240
defb 118,0,148,3,165,254,160,232,66,101,3,37,208,101,168,57,146,247,185,238
defb 51,188,248,74,63,102,123,137,233,18,253,240,53,149,173,101,252,165,129,127
defb 55,0,166,248,154,1,249,74,127,66,152,192,145,255,255,165,15,40,252,96
defb 132,7,231,248,127,104,128,192,202,224,224,77,165,1,1,34,255,3,74,224
defb 74,3,41,15,24,102,116,185,59,166,72,130,240,98,4,180,144,144,63,150
defb 66,90,132,37,9,73,32,161,240,119,64,72,189,31,241,217,232,0,192,161
defb 63,24,154,128,3,247,10,63,26,18,134,3,32,199,73,136,5,170,15,7
defb 66,150,248,8,15,255,252,190,104,7,165,63,41,240,105,128,2,145,7,160
defb 0,8,102,132,165,65,41,104,134,192,34,172,151,146,127,146,128,42,86,231
defb 206,170,56,224,2,129,4,41,251,34,247,128,2,88,7,189,207,113,157,50
defb 64,74,15,104,238,73,96,32,227,4,161,40,82,68,18,150,252,138,31,158
defb 2,128,31,105,127,70,146,135,150,252,149,127,154,135,185,49,154,88,128,9
defb 132,7,164,144,245,171,232,0,82,136,10,121,164,192,168,63,137,15,128,96
defb 8,92,247,57,156,153,32,40,255,166,31,39,254,64,70,64,98,33,40,45
defb 75,146,0,154,63,216,18,34,34,148,38,38,98,133,224,164,192,164,3,42
defb 254,134,254,138,63,142,26,3,65,213,222,0,226,217,0,137,192,31,41,255
defb 41,242,106,63,145,7,134,132,169,9,47,72,2,138,4,0,160,63,41,15
defb 150,57,146,135,185,233,73,60,22,156,252,209,215,173,64,160,130,0,134,224
defb 154,235,127,24,40,7,57,46,114,138,74,192,128,29,246,188,40,127,177,193
defb 98,0,166,7,225,83,196,70,32,243,128,165,7,40,255,74,230,2,128,15
defb 34,2,255,10,228,26,0,23,157,242,218,0,192,90,31,86,11,116,165,113
defb 41,85,195,252,93,0,196,207,108,164,116,223,132,95,96,1,169,92,231,18
defb 92,96,41,240,219,190,176,186,97,64,134,33,40,83,201,74,3,91,158,28
defb 190,218,1,19,25,100,18,147,68,189,46,74,72,49,119,46,93,125,112,0
defb 241,203,219,104,38,98,0,138,1,7,82,168,248,7,105,252,40,15,161,63
defb 26,240,90,15,160,15,57,254,79,158,49,124,100,28,172,114,193,26,30,99
defb 157,59,128,151,255,232,45,86,125,238,103,121,195,60,152,134,37,43,82,149
defb 64,182,1,91,164,252,225,127,31,190,198,16,120,191,246,18,218,18,161,32
defb 38,24,132,170,170,86,224,106,7,75,6,48,108,254,12,254,159,254,215,117
defb 240,137,127,129,227,113,252,95,120,176,129,3,254,116,31,156,222,232,126,19
defb 161,215,127,49,91,120,128,254,88,49,16,148,33,65,243,40,220,96,51,192
defb 192,1,4,146,66,4,160,4,103,57,42,220,123,1,14,95,144,104,0,152
defb 56,252,133,171,156,130,162,138,82,128,26,3,106,238,130,204,129,223,49,54
defb 172,11,255,240,28,31,86,82,54,0,18,138,7,0,6,149,240,40,0,5
defb 34,28,147,170,49,7,93,38,84,27,196,146,113,132,184,200,2,63,41,234
defb 82,146,208,109,0,235,64,56,102,1,30,138,20,160,224,33,128,115,34,137
defb 146,240,130,62,198,198,252,8,138,220,9,240,1,161,15,235,144,24,101,0
defb 106,3,132,254,160,248,90,63,22,128,120,70,10,16,240,161,9,145,3,134
defb 36,242,64,68,160,2,11,37,42,92,98,39,8,30,64,53,124,192,166,0
defb 139,210,157,125,108,109,1,136,0,139,120,252,241,182,233,240,130,18,142,6
defb 55,135,255,122,0,128,16,160,252,104,95,66,133,31,160,48,20,159,151,29
defb 113,245,89,0,104,1,153,123,131,32,244,254,222,0,173,124,224,205,210,132
defb 0,214,120,104,252,182,96,131,33,240,127,29,61,112,218,0,192,4,170,1
defb 248,6,132,31,47,15,151,145,254,11,63,134,184,150,240,128,224,118,1,8
defb 60,56,108,112,4,136,252,0,152,192,63,252,82,148,252,42,0,129,240,161
defb 15,8,132,3,224,82,144,15,117,98,65,138,82,75,31,121,0,128,238,56
defb 252,27,62,88,130,161,252,13,26,107,248,71,117,0,165,127,88,132,0,240
defb 2,26,56,202,92,101,64,144,7,135,12,139,220,156,192,22,64,9,146,182
defb 218,90,153,15,221,124,198,28,80,214,236,83,102,1,123,191,192,98,7,254
defb 20,161,224,2,132,7,104,112,64,35,64,71,143,254,242,125,236,239,240,239
defb 252,244,192,10,71,78,254,1,160,5,240,220,224,6,242,192,126,40,45,45
defb 247,178,29,135,198,143,222,195,189,193,40,254,227,174,194,192,148,5,255,251
defb 188,255,120,14,255,192,212,191,250,254,159,172,189,222,80,242,127,206,243,251
defb 190,207,192,205,249,80,128,238,212,192,26,45,30,250,231,130,192,192,254,242
defb 192,77,135,190,206,226,166,237,194,215,66,255,208,186,252,106,129,135,194,221
defb 200,232,178,40,28,223,64,126,121,178,125,192,200,180,247,206,104,171,45,76
defb 147,38,124,102,222,178,194,95,192,117,159,120,204,120,192,77,206,46,254,41
defb 5,116,133,238,253,63,202,225,190,120,50,225,232,210,104,67,215,234,213,254
defb 117,85,88

mapdata2:
defb 130,3,133,0,160,4,104,0,42,3,162,24,30,6,79,192,60,188,62,194
defb 246,48,254,227,38,214,223,198,192,165,3,35,32,32,223,188,248,250,192,24
defb 87,143,188,50,249,239,66,174,30,192,26,48,95,132,255,238,192,255,196,126
defb 15,211,185,250,130,240,192,63,242,133,192,155,22,16,34,232,254,34,237,194
defb 211,66,255,192,190,234,201,255,16,205,2,194,221,192,143,14,14,197,254,192
defb 201,254,255,192,190,125,192,184,8,208,191,23,254,220,192,142,4,192,8,243
defb 10,10,194,255,255,194,192,98,6,6,94,190,185,17,194,61,192,174,0,254
defb 152,1,14,15,35,17,16,132,192,248,254,230,1,8,192,242,2,254,128,0
defb 40,1,254,63,249,202,120,190,95,189,189,254,232,225,192,104,0,161,0,53
defb 85,88
